import java.util.*;
import javax.swing.*;
import java.awt.*;
import java.awt.event.*;
public class SoloGreedGame extends JPanel implements MouseListener
{
    private ArrayList<MiniButton> buttons;
    private Die[] dice;
    private MiniButton sit,stand;
    private String message;
    private int rollTotal, roundTotal, total, round;
    public static final int SIZE = 50;
    public static final int WIDTH = 600;
    public static final int HEIGHT = 500;

    public SoloGreedGame()  // constructor
    {
        rollTotal=0;
        roundTotal=0;
        total=0;
        round = 1;
        dice = new Die[2];
        dice[0] = new Die(2*SIZE+getWidth()/3, 3*SIZE+getHeight()/5, 2*SIZE);
        dice[1] = new Die(5*SIZE+getWidth()/3, 3*SIZE+getHeight()/5, 2*SIZE);
        buttons =  new ArrayList<MiniButton>();
        sit = new MiniButton( "   SIT ", SIZE + getWidth()/3, SIZE+getHeight()/5, 2*SIZE, SIZE);
        stand = new MiniButton( "STAND", 5*SIZE+getWidth()/3, SIZE+getHeight()/5, 2*SIZE, SIZE);
        buttons.add(sit);
        buttons.add(stand);
        message = "Greed (Solo Version)";
        addMouseListener(this);
    }

    public void paintComponent(Graphics g)
    {
        setBackground(new Color(255,220,200) );
        super.paintComponent(g);
        for(MiniButton b : buttons)
            b.draw(g);
        for(Die d : dice)
            d.draw(g);
        g.setColor(Color.BLACK);
        rollTotal = dice[0].getValue() +dice[1].getValue();
        g.drawString("Die show a total of "+ rollTotal, 20, 400 );
        g.drawString("Round total of "+ roundTotal, 20, 425 );
        g.drawString("Grand total of "+ total, 20, 450 );
        g.drawString(message, 20, 25);
        g.drawString("Round "+round, getWidth() - 120, 25);
    }

    public static void main(String[] args)
    {
        JFrame window = new JFrame();
        window.setSize(WIDTH, HEIGHT);
        Container c = window.getContentPane();
        c.add(new SoloGreedGame());
        window.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        window.setVisible(true);
    }

    public void mouseReleased(MouseEvent e) 
    {
        int x = e.getX();
        int y = e.getY();
        if ( sit.contains(x,y) ){
            message="sit was pressed";
            // record the round total, zero out round
        }else if (stand.contains(x,y) ){
            message = "Stand button was pressed";
            // 
            for(Die d : dice)
                d.roll();
            // check for 2 to see if end of round
        }
        
            
        repaint();
    }

    public void mousePressed(MouseEvent e) { }

    public void mouseEntered(MouseEvent e) { }

    public void mouseExited(MouseEvent e) { }

    public void mouseClicked(MouseEvent e) { }
}